<?php
header('Content-Type: application/json');
require_once 'db.php'; // Incluye tu conexión PDO

$response = [
    'success' => false,
    'addresses' => [],
    'error' => ''
];

try {
    if (!isset($_POST['user_id']) || !is_numeric($_POST['user_id'])) {
        throw new Exception('user_id requerido');
    }
    $user_id = intval($_POST['user_id']);

    $stmt = $pdo->prepare('SELECT * FROM addresses WHERE user_id = :user_id');
    $stmt->execute(['user_id' => $user_id]);
    $addresses = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $response['success'] = true;
    $response['addresses'] = $addresses;
} catch (Exception $e) {
    $response['error'] = $e->getMessage();
}

echo json_encode($response);
?>