<?php
header('Content-Type: application/json');
require 'db.php';

// CORS preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
    header("Access-Control-Allow-Headers: Content-Type, Authorization");
    header("HTTP/1.1 200 OK");
    exit();
}

// CORS para la peticin real
header("Access-Control-Allow-Origin: *");

try {
    // Solo categoras con al menos un producto
    $sql = "
        SELECT DISTINCT c.*
        FROM categories c
        JOIN products p ON p.category_id = c.id
    ";
    $stmt = $pdo->query($sql);
    $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode(['success' => true, 'categories' => $categories]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>