<?php
header('Content-Type: application/json; charset=utf-8');
require_once 'db.php'; // Debe exponer $pdo (PDO conectado)

function json_fail($msg) {
    echo json_encode(['success' => false, 'error' => $msg], JSON_UNESCAPED_UNICODE);
    exit;
}

function json_success(array $payload = []) {
    echo json_encode(['success' => true] + $payload, JSON_UNESCAPED_UNICODE);
    exit;
}

$order_id = isset($_POST['order_id']) ? (int)$_POST['order_id'] : 0;
$user_id  = isset($_POST['user_id'])  ? (int)$_POST['user_id']  : 0;

if (!$order_id || !$user_id) {
    json_fail('Missing order_id or user_id');
}

try {
    $stmt = $pdo->prepare('SELECT id FROM orders WHERE id = ? AND user_id = ? LIMIT 1');
    $stmt->execute([$order_id, $user_id]);
    if (!$stmt->fetch()) {
        json_fail('Order not found or not owned by user');
    }

    $historyStmt = $pdo->prepare(
        'SELECT h.status,
                COALESCE(d.status_label, h.status) AS status_label,
                h.note,
                h.changed_at
           FROM order_status_history h
      LEFT JOIN order_status_definitions d ON d.status_code = h.status
          WHERE h.order_id = ?
          ORDER BY h.changed_at ASC, h.id ASC'
    );
    $historyStmt->execute([$order_id]);
    $rows = $historyStmt->fetchAll(PDO::FETCH_ASSOC);

    $history = [];
    foreach ($rows as $row) {
        $timestamp = $row['created_at'] ?? null;
        $history[] = [
            'status'     => (string)$row['status_label'],
            'changed_at' => $timestamp ? date(DATE_ATOM, strtotime($timestamp)) : null,
            'note'       => $row['note'] !== null ? (string)$row['note'] : null,
        ];
    }

    json_success([
        'order_id' => $order_id,
        'history'  => $history,
    ]);
} catch (Exception $e) {
    json_fail('DB error');
}