<?php
header('Content-Type: application/json');
require 'db.php';

// CORS preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
    header("Access-Control-Allow-Headers: Content-Type, Authorization");
    header("HTTP/1.1 200 OK");
    exit();
}
header("Access-Control-Allow-Origin: *");

try {
    $stmt = $pdo->query('SELECT * FROM products');
    $products = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $today = date('Y-m-d');
    $dayOfWeek = strtolower(date('l')); // Ej: 'monday'

    foreach ($products as $key => &$product) {
        // Si es especial, verificar en la tabla specials
        if (!empty($product['is_special']) && intval($product['is_special']) === 1) {
            $specialStmt = $pdo->prepare("
                SELECT * FROM specials
                WHERE producto_id = ?
                  AND activo = 1
                  AND fecha_inicio <= ?
                  AND fecha_fin >= ?
                  AND (day_of_week IS NULL OR day_of_week = '' OR LOCATE(?, LOWER(day_of_week)) > 0)
                LIMIT 1
            ");
            $specialStmt->execute([$product['id'], $today, $today, $dayOfWeek]);
            $special = $specialStmt->fetch(PDO::FETCH_ASSOC);

            // Si no hay promocin activa, quitar el producto
            if (!$special) {
                unset($products[$key]);
                continue;
            }
            // Puedes agregar info extra del especial si lo necesitas:
            $product['special_info'] = $special;
        }

        // Obtener todos los tama09os
        $sizeStmt = $pdo->prepare('SELECT name, slices, price FROM product_sizes WHERE product_id = ?');
        $sizeStmt->execute([$product['id']]);
        $sizes = $sizeStmt->fetchAll(PDO::FETCH_ASSOC);
        $product['sizes'] = $sizes;

        // Obtener el menor tama09o y precio
        $minSizeStmt = $pdo->prepare('SELECT name, price FROM product_sizes WHERE product_id = ? ORDER BY price ASC LIMIT 1');
        $minSizeStmt->execute([$product['id']]);
        $minSize = $minSizeStmt->fetch(PDO::FETCH_ASSOC);
        $product['base_size'] = $minSize ? $minSize['name'] : null;
        $product['base_price'] = $minSize ? $minSize['price'] : null;

        // Obtener toppings/adicionales
        $toppingStmt = $pdo->prepare('SELECT name, price FROM product_toppings WHERE product_id = ?');
        $toppingStmt->execute([$product['id']]);
        $product['toppings'] = $toppingStmt->fetchAll(PDO::FETCH_ASSOC);
        
        // Obtener promedio de rating y cantidad de reviews
        $reviewStmt = $pdo->prepare('SELECT COUNT(*) as total, AVG(rating) as average FROM reviews WHERE product_id = ?');
        $reviewStmt->execute([$product['id']]);
        $reviewData = $reviewStmt->fetch(PDO::FETCH_ASSOC);
        $product['reviews_count'] = $reviewData['total'] ? intval($reviewData['total']) : 0;
        $product['reviews_average'] = $reviewData['average'] ? round(floatval($reviewData['average']), 2) : null;
    }

    // Reindexar el array para evitar huecos si se eliminaron productos
    $products = array_values($products);

    echo json_encode(['success' => true, 'products' => $products]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>