<?php
header('Content-Type: application/json; charset=utf-8');
require_once 'db.php'; // Debe exponer $pdo (PDO conectado)

function json_fail($msg) {
    echo json_encode(['success' => false, 'error' => $msg], JSON_UNESCAPED_UNICODE);
    exit;
}

function json_success(array $payload = []) {
    echo json_encode(['success' => true] + $payload, JSON_UNESCAPED_UNICODE);
    exit;
}

// Recibe fecha y día de la semana (ejemplo: '2025-10-04', 'saturday')
$date = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d');
$dayOfWeek = isset($_GET['day_of_week']) ? strtolower($_GET['day_of_week']) : strtolower(date('l')); // 'monday', 'tuesday', etc.

try {
    $stmt = $pdo->prepare(
        "SELECT s.*, p.title AS product_title
         FROM specials s
         JOIN products p ON p.id = s.producto_id
         WHERE s.activo = 1
           AND s.fecha_inicio <= ?
           AND s.fecha_fin >= ?
           AND (s.day_of_week IS NULL OR s.day_of_week = '' OR LOCATE(?, LOWER(s.day_of_week)) > 0)"
    );
    $stmt->execute([$date, $date, $dayOfWeek]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $specials = [];
    foreach ($rows as $row) {
        $specials[] = [
            'id'          => (int)$row['id'],
            'titulo'      => $row['titulo'],
            'imagen'      => $row['imagen'],
            'producto_id' => (int)$row['producto_id'],
            'product_title' => $row['product_title'],
            'fecha_inicio'=> $row['fecha_inicio'],
            'fecha_fin'   => $row['fecha_fin'],
            'day_of_week' => $row['day_of_week'],
            'descripcion' => $row['descripcion'],
            'orden'       => (int)$row['orden'],
        ];
    }

    json_success(['specials' => $specials]);
} catch (Exception $e) {
    json_fail('DB error');
}