<?php
header('Content-Type: application/json');
require 'db.php';

date_default_timezone_set('UTC');

// 1. Check if the request method is OPTIONS (the preflight)
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    // 2. Respond with the necessary CORS headers for the preflight
    header("Access-Control-Allow-Origin: *"); // Allow your origin
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS"); // Allow the methods you use
    header("Access-Control-Allow-Headers: Content-Type, Authorization"); // Allow the custom headers you send
    header("HTTP/1.1 200 OK"); // **Crucially, ensure a 200 OK status**
    exit(); // Stop execution after sending the preflight response
}

// 3. Add the CORS header for the actual request (GET/POST) as well
header("Access-Control-Allow-Origin: *");

try {
    $data = json_decode(file_get_contents('php://input'), true, 512, JSON_THROW_ON_ERROR);
} catch (Throwable $error) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Solicitud inválida']);
    exit;
}

$email = trim($data['email'] ?? '');
$password = $data['password'] ?? '';

if ($email === '' || $password === '') {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Email y contraseña son requeridos']);
    exit;
}

$stmt = $pdo->prepare('SELECT id, name, email, password, role FROM users WHERE email = ? LIMIT 1');
$stmt->execute([$email]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if ($user && password_verify($password, $user['password'])) {
    $token = bin2hex(random_bytes(32));

    echo json_encode([
        'success' => true,
        'token' => $token,
        'user' => [
            'id' => (int) $user['id'],
            'name' => $user['name'],
            'email' => $user['email'],
            'role' => $user['role'] ?? 'admin'
        ]
    ]);
    exit;
}

http_response_code(401);
echo json_encode(['success' => false, 'error' => 'Credenciales inválidas']);
