<?php
header('Content-Type: application/json');
require 'db.php'; // Tu conexi���n PDO

// 1. Check if the request method is OPTIONS (the preflight)
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    // 2. Respond with the necessary CORS headers for the preflight
    header("Access-Control-Allow-Origin: *"); // Allow your origin
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS"); // Allow the methods you use
    header("Access-Control-Allow-Headers: Content-Type, Authorization"); // Allow the custom headers you send
    header("HTTP/1.1 200 OK"); // **Crucially, ensure a 200 OK status**
    exit(); // Stop execution after sending the preflight response
}

// 3. Add the CORS header for the actual request (GET/POST) as well
header("Access-Control-Allow-Origin: *");

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

try {
    // Datos principales del producto
    $stmt = $pdo->prepare('SELECT * FROM products WHERE id = ?');
    $stmt->execute([$id]);
    $product = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($product) {
        // Tama���os
        $sizeStmt = $pdo->prepare('SELECT name, slices, price FROM product_sizes WHERE product_id = ?');
        $sizeStmt->execute([$id]);
        $product['sizes'] = $sizeStmt->fetchAll(PDO::FETCH_ASSOC);

        // Menor tama���o y precio base
        $minSizeStmt = $pdo->prepare('SELECT name, price FROM product_sizes WHERE product_id = ? ORDER BY price ASC LIMIT 1');
        $minSizeStmt->execute([$id]);
        $minSize = $minSizeStmt->fetch(PDO::FETCH_ASSOC);
        $product['base_size'] = $minSize ? $minSize['name'] : null;
        $product['base_price'] = $minSize ? $minSize['price'] : null;

        // Toppings/adicionales
        $toppingStmt = $pdo->prepare('SELECT name, price FROM product_toppings WHERE product_id = ?');
        $toppingStmt->execute([$id]);
        $product['toppings'] = $toppingStmt->fetchAll(PDO::FETCH_ASSOC);

        // Promedio y cantidad de reviews
        $reviewStatsStmt = $pdo->prepare('SELECT COUNT(*) as total, AVG(rating) as average FROM reviews WHERE product_id = ?');
        $reviewStatsStmt->execute([$id]);
        $reviewStats = $reviewStatsStmt->fetch(PDO::FETCH_ASSOC);
        $product['reviews_count'] = $reviewStats['total'] ? intval($reviewStats['total']) : 0;
        $product['reviews_average'] = $reviewStats['average'] ? round(floatval($reviewStats['average']), 2) : null;

        // Listado de reviews (���ltimos 10)
        $reviewsStmt = $pdo->prepare('SELECT user_id, rating, comment, created_at FROM reviews WHERE product_id = ? ORDER BY created_at DESC LIMIT 10');
        $reviewsStmt->execute([$id]);
        $product['reviews'] = $reviewsStmt->fetchAll(PDO::FETCH_ASSOC);

        echo json_encode(['success' => true, 'product' => $product]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Producto no encontrado']);
    }
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>