<?php
header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: POST, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type, Authorization');
    http_response_code(200);
    exit;
}

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error_code' => 'method_not_allowed', 'error' => 'Method not allowed']);
    exit;
}

if (!isset($_FILES['image'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error_code' => 'missing_file', 'error' => 'No file received']);
    exit;
}

$file = $_FILES['image'];

if (!isset($file['error']) || $file['error'] !== UPLOAD_ERR_OK) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error_code' => 'upload_error', 'error' => 'Upload failed']);
    exit;
}

// Limit size to 5MB
if (!isset($file['size']) || $file['size'] > 5 * 1024 * 1024) {
    http_response_code(413);
    echo json_encode(['success' => false, 'error_code' => 'too_large', 'error' => 'File exceeds 5MB limit']);
    exit;
}

$finfo = finfo_open(FILEINFO_MIME_TYPE);
$mimeType = finfo_file($finfo, $file['tmp_name']);
finfo_close($finfo);

$allowedMimes = [
    'image/jpeg' => 'jpg',
    'image/png' => 'png',
    'image/webp' => 'webp',
    'image/gif' => 'gif',
    'image/heic' => 'heic',
    'image/heif' => 'heic'
];

if (!isset($allowedMimes[$mimeType])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error_code' => 'invalid_type', 'error' => 'Unsupported file type']);
    exit;
}

$uploadDir = __DIR__ . '/uploads/products/';
$baseUrl = 'https://fvfallstart.com/uploads/products/';

if (!is_dir($uploadDir)) {
    if (!mkdir($uploadDir, 0755, true) && !is_dir($uploadDir)) {
        http_response_code(500);
        echo json_encode(['success' => false, 'error_code' => 'server_error', 'error' => 'Could not create upload directory']);
        exit;
    }
}

$extension = $allowedMimes[$mimeType];

do {
    $random = bin2hex(random_bytes(8));
    $filename = date('Ymd_His') . '_' . $random . '.' . $extension;
    $destination = $uploadDir . $filename;
} while (file_exists($destination));

if (!move_uploaded_file($file['tmp_name'], $destination)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error_code' => 'server_error', 'error' => 'Could not move uploaded file']);
    exit;
}

$publicUrl = $baseUrl . $filename;

echo json_encode([
    'success' => true,
    'filename' => $filename,
    'url' => $publicUrl,
    'mime' => $mimeType,
    'size' => $file['size']
], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
