<?php
header('Content-Type: application/json; charset=utf-8');

$UPLOAD_DIR = __DIR__ . '/uploads/receipts/';
$BASE_URL   = 'https://fvfallstart.com/uploads/receipts/';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  echo json_encode(['success'=>false,'error_code'=>'method_not_allowed','error'=>'Method not allowed']);
  exit;
}

if (!isset($_POST['user_id']) || !is_numeric($_POST['user_id'])) {
  http_response_code(400);
  echo json_encode(['success'=>false,'error_code'=>'invalid_user','error'=>'Invalid user_id']);
  exit;
}
$user_id = (int)$_POST['user_id'];

if (!isset($_FILES['receipt'])) {
  http_response_code(400);
  echo json_encode(['success'=>false,'error_code'=>'missing_file','error'=>'File not provided']);
  exit;
}

$file = $_FILES['receipt'];

if ($file['error'] !== UPLOAD_ERR_OK) {
  http_response_code(400);
  echo json_encode(['success'=>false,'error_code'=>'upload_error','error'=>'Upload failed']);
  exit;
}

// Size limit 5MB
if ($file['size'] > 5 * 1024 * 1024) {
  http_response_code(413);
  echo json_encode(['success'=>false,'error_code'=>'too_large','error'=>'File exceeds 5MB limit']);
  exit;
}

$finfo = finfo_open(FILEINFO_MIME_TYPE);
$mime  = finfo_file($finfo, $file['tmp_name']);
finfo_close($finfo);

$allowed = [
  'image/jpeg' => 'jpg',
  'image/png'  => 'png',
  'image/webp' => 'webp',
  'image/heic' => 'heic',
  'image/heif' => 'heic',
];

if (!isset($allowed[$mime])) {
  http_response_code(400);
  echo json_encode(['success'=>false,'error_code'=>'invalid_type','error'=>'Unsupported file type']);
  exit;
}

if (!is_dir($UPLOAD_DIR)) {
  mkdir($UPLOAD_DIR, 0755, true);
}

$ext = $allowed[$mime];
$random  = bin2hex(random_bytes(4));
$filename = $user_id . '_' . time() . '_' . $random . '.' . $ext;
$dest = $UPLOAD_DIR . $filename;

if (!move_uploaded_file($file['tmp_name'], $dest)) {
  http_response_code(500);
  echo json_encode(['success'=>false,'error_code'=>'server_error','error'=>'Could not move uploaded file']);
  exit;
}

echo json_encode([
  'success'  => true,
  'filename' => $filename,
  'url'      => $BASE_URL . $filename
]);