<?php
header('Content-Type: application/json');
require_once 'db.php'; // Incluye tu conexión PDO

$response = [
    'success' => false,
    'message' => '',
    'error' => ''
];

try {
    // Validar datos
    if (
        !isset($_POST['product_id']) || !is_numeric($_POST['product_id']) ||
        !isset($_POST['user_id']) || !is_numeric($_POST['user_id']) ||
        !isset($_POST['rating']) || !is_numeric($_POST['rating']) ||
        !isset($_POST['comment']) || trim($_POST['comment']) === ''
    ) {
        throw new Exception('Datos incompletos');
    }

    $product_id = intval($_POST['product_id']);
    $user_id = intval($_POST['user_id']);
    $rating = intval($_POST['rating']);
    $comment = trim($_POST['comment']);

    // Insertar la reseña
    $stmt = $pdo->prepare('INSERT INTO reviews (product_id, user_id, rating, comment, created_at) VALUES (:product_id, :user_id, :rating, :comment, NOW())');
    $stmt->execute([
        'product_id' => $product_id,
        'user_id' => $user_id,
        'rating' => $rating,
        'comment' => $comment
    ]);

    $response['success'] = true;
    $response['message'] = 'Reseña agregada correctamente';
} catch (Exception $e) {
    $response['error'] = $e->getMessage();
}

echo json_encode($response);
?>