<?php
header('Content-Type: application/json; charset=utf-8');
require_once 'db.php'; // Debe exponer $pdo (PDO conectado)

function json_fail($msg) {
    echo json_encode(['success' => false, 'error' => $msg], JSON_UNESCAPED_UNICODE);
    exit;
}

function json_success(array $payload = []) {
    echo json_encode(['success' => true] + $payload, JSON_UNESCAPED_UNICODE);
    exit;
}

$user_id = isset($_POST['user_id']) ? (int)$_POST['user_id'] : 0;
if (!$user_id) {
    json_fail('Missing user_id');
}

try {
    $stmt = $pdo->prepare(
        'SELECT id, order_number, user_id, address_id, total, status, notes,
                transfer_reference, receipt_filename,
                pickup_latitude, pickup_longitude,
                delivery_latitude, delivery_longitude,
                distance_km, estimated_delivery_at,
                driver_name, driver_phone, driver_avatar, driver_rating,
                created_at, updated_at
           FROM orders
          WHERE user_id = ?
          ORDER BY created_at DESC'
    );
    $stmt->execute([$user_id]);
    $orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $orderIds = array_column($orders, 'id');
    $itemsByOrder = [];

    if ($orderIds) {
        $placeholders = implode(',', array_fill(0, count($orderIds), '?'));
        $itemsStmt = $pdo->prepare(
            'SELECT order_id, product_id, quantity, price, name, image
               FROM order_items
              WHERE order_id IN (' . $placeholders . ')
              ORDER BY id ASC'
        );
        $itemsStmt->execute($orderIds);
        $itemsRows = $itemsStmt->fetchAll(PDO::FETCH_ASSOC);

        foreach ($itemsRows as $row) {
            $orderId = (int)$row['order_id'];
            if (!isset($itemsByOrder[$orderId])) {
                $itemsByOrder[$orderId] = [];
            }
            $lineTotal = ((float)$row['quantity']) * ((float)$row['price']);
            $itemsByOrder[$orderId][] = [
                'product_id' => (int)$row['product_id'],
                'quantity'   => (int)$row['quantity'],
                'price'      => (float)$row['price'],
                'name'       => $row['name'] !== null ? (string)$row['name'] : null,
                'image'      => $row['image'] !== null ? (string)$row['image'] : null,
                'line_total' => $lineTotal,
            ];
        }
    }

    $output = [];
    foreach ($orders as $order) {
        $id = (int)$order['id'];
        $items = $itemsByOrder[$id] ?? [];
        $output[] = [
            'id'                   => $id,
            'order_number'         => $order['order_number'] !== null ? (string)$order['order_number'] : null,
            'user_id'              => (int)$order['user_id'],
            'address_id'           => (int)$order['address_id'],
            'total'                => (float)$order['total'],
            'status'               => $order['status'] !== null ? (string)$order['status'] : null,
            'notes'                => $order['notes'] !== null ? (string)$order['notes'] : null,
            'transfer_reference'   => $order['transfer_reference'] !== null ? (string)$order['transfer_reference'] : null,
            'receipt_filename'     => $order['receipt_filename'] !== null ? (string)$order['receipt_filename'] : null,
            'item_count'           => 0,
            'pickup_latitude'      => $order['pickup_latitude']      !== null ? (float)$order['pickup_latitude'] : null,
            'pickup_longitude'     => $order['pickup_longitude']     !== null ? (float)$order['pickup_longitude'] : null,
            'delivery_latitude'    => $order['delivery_latitude']    !== null ? (float)$order['delivery_latitude'] : null,
            'delivery_longitude'   => $order['delivery_longitude']   !== null ? (float)$order['delivery_longitude'] : null,
            'distance_km'          => $order['distance_km']          !== null ? (float)$order['distance_km'] : null,
            'estimated_delivery_at'=> $order['estimated_delivery_at']!== null ? (string)$order['estimated_delivery_at'] : null,
            'driver_name'          => $order['driver_name']          !== null ? (string)$order['driver_name'] : null,
            'driver_phone'         => $order['driver_phone']         !== null ? (string)$order['driver_phone'] : null,
            'driver_avatar'        => $order['driver_avatar']        !== null ? (string)$order['driver_avatar'] : null,
            'driver_rating'        => $order['driver_rating']        !== null ? (float)$order['driver_rating'] : null,
            'created_at'           => $order['created_at'] !== null ? (string)$order['created_at'] : null,
            'updated_at'           => $order['updated_at'] !== null ? (string)$order['updated_at'] : null,
            'items'                => $items,
        ];
    }

    json_success(['orders' => $output]);
} catch (Exception $e) {
    json_fail('DB error');
}