<?php
header('Content-Type: application/json');
require 'db.php'; // Tu conexin PDO

try {
    // Obtener todos los productos
    $stmt = $pdo->query('SELECT * FROM products');
    $products = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($products as &$product) {
        // Obtener todos los tama09os
        $sizeStmt = $pdo->prepare('SELECT name, slices, price FROM product_sizes WHERE product_id = ?');
        $sizeStmt->execute([$product['id']]);
        $sizes = $sizeStmt->fetchAll(PDO::FETCH_ASSOC);
        $product['sizes'] = $sizes;

        // Obtener el menor tama09o y precio
        $minSizeStmt = $pdo->prepare('SELECT name, price FROM product_sizes WHERE product_id = ? ORDER BY price ASC LIMIT 1');
        $minSizeStmt->execute([$product['id']]);
        $minSize = $minSizeStmt->fetch(PDO::FETCH_ASSOC);
        $product['base_size'] = $minSize ? $minSize['name'] : null;
        $product['base_price'] = $minSize ? $minSize['price'] : null;

        // Obtener toppings/adicionales
        $toppingStmt = $pdo->prepare('SELECT name, price FROM product_toppings WHERE product_id = ?');
        $toppingStmt->execute([$product['id']]);
        $product['toppings'] = $toppingStmt->fetchAll(PDO::FETCH_ASSOC);
        
        // Obtener promedio de rating y cantidad de reviews
        $reviewStmt = $pdo->prepare('SELECT COUNT(*) as total, AVG(rating) as average FROM reviews WHERE product_id = ?');
        $reviewStmt->execute([$product['id']]);
        $reviewData = $reviewStmt->fetch(PDO::FETCH_ASSOC);
        $product['reviews_count'] = $reviewData['total'] ? intval($reviewData['total']) : 0;
        $product['reviews_average'] = $reviewData['average'] ? round(floatval($reviewData['average']), 2) : null;
    }

    echo json_encode(['success' => true, 'products' => $products]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>