<?php

// Carpeta donde se guardarán las imágenes
$target_dir = "uploads/";

// Crear la carpeta si no existe
if (!file_exists($target_dir)) {
    mkdir($target_dir, 0777, true);
}

$response = [];

if (isset($_FILES["image"])) {
    $file = $_FILES["image"];
    $original_name = basename($file["name"]);
    $file_extension = pathinfo($original_name, PATHINFO_EXTENSION);
    
    // Generar un nombre de archivo único usando un timestamp
    $unique_name = uniqid() . '.' . $file_extension;
    $target_file = $target_dir . $unique_name;
    
    // Validaciones (puedes agregar más aquí)
    $uploadOk = true;
    
    // Mover el archivo subido
    if ($uploadOk) {
        if (move_uploaded_file($file["tmp_name"], $target_file)) {
            $response["success"] = true;
            $response["url"] = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'] . '/' . $target_file;
        } else {
            $response["success"] = false;
            $response["error"] = "Error al subir la imagen.";
        }
    }
} else {
    $response["success"] = false;
    $response["error"] = "No se recibió ninguna imagen.";
}

header('Content-Type: application/json');
echo json_encode($response);

/*$target_dir = "uploads/";

// Crear la carpeta si no existe
if (!file_exists($target_dir)) {
    mkdir($target_dir, 0777, true);
}

$response = [];

if (isset($_FILES["image"])) {
    $file = $_FILES["image"];
    $target_file = $target_dir . basename($file["name"]);

    // Puedes agregar validaciones aquí (tipo, tamaño, etc.)
    if (move_uploaded_file($file["tmp_name"], $target_file)) {
        $response["success"] = true;
        $response["url"] = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'] . '/' . $target_file;
    } else {
        $response["success"] = false;
        $response["error"] = "Error al subir la imagen.";
    }
} else {
    $response["success"] = false;
    $response["error"] = "No se recibió ninguna imagen.";
}

header('Content-Type: application/json');
echo json_encode($response);*/
?>